// priority: 5
//   __   ___   _    _  _ ___ _    ___ ___   _      _____
//   \ \ / /_\ | |  | || | __| |  / __|_ _| /_\    /__  /
//    \ V / _ \| |__| __ | _|| |__\__ \| | / _ \     / /
//     \_/_/ \_\____|_||_|___|____|___/___/_/ \_\   /_/
//                       

/**
 * @file First Start Script - Handles the first time a player joins a world (whether single- or multiplayer).
 * 
 * This includes things like introductory chat messages + links, starting items, and anything else that needs 
 * to be set just once the first time a player connects.
 * 
 * @copyright Valhelsia Inc 2024
 */

/**
 * Player Login Event Handler
 */
PlayerEvents.loggedIn(event => {
  if (!event.player.stages.has('first_start')) {
    event.player.stages.add('first_start');

    event.player.tell(Text.translate('valhelsia.chat.first_start_message'));
    event.player.tell(Text.translate('valhelsia.chat.discord_link').blue().underlined().click('https://discord.valhelsia.net/'));
    event.player.tell(Text.translate('valhelsia.chat.wiki'));
    event.player.tell(Text.translate('valhelsia.chat.wiki_link').blue().underlined().click('https://wiki.valhelsia.net/'));
    event.player.tell(Text.translate('valhelsia.chat.last_start_message'));

    event.player.give(Item.of('eccentrictome:tome', ''));
  }

  // Note: If added to in the future, creating multiple stages would allow players updating the pack to receive any new
  // "first start" items / settings / whatever.
  // eg. instead of 'first_start', use 'first_start_v2', 'first_start_v3' to allow versioning the first start script.
});